<?php
session_start();
require 'si2h6234_dbaxel';

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }

$id = $_SESSION['user_id'];
$user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = '$id'"));

// Hitung total event
$total_event_query = mysqli_query($conn, "SELECT COUNT(*) as total FROM events");
$total_event = ($total_event_query) ? mysqli_fetch_assoc($total_event_query)['total'] : 0;

// Ambil semua event urut tanggal
$events_query = mysqli_query($conn, "SELECT * FROM events ORDER BY date ASC");

$hero_events = [];
$grid_events = [];
$counter = 0;

while($row = mysqli_fetch_assoc($events_query)) {
    if ($counter < 2) {
        $hero_events[] = $row; 
    }
    $grid_events[] = $row; 
    $counter++;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Titik Kumpul</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

    <div class="mobile-container">
        
        <?php if(file_exists('sidebar.php')) include 'sidebar.php'; ?>

        <div class="header-home">
            <div style="font-size: 20px; cursor: pointer; color: #333;" onclick="toggleSidebar()">
                <i class="fa-solid fa-bars"></i>
            </div>
            
            <div class="header-icons" style="display: flex; align-items: center; gap: 15px;">
                <a href="notification.php" style="text-decoration: none; color: #333; font-size: 20px;">
                    <i class="fa-regular fa-bell"></i>
                </a>
                
                <a href="profile.php" class="avatar" style="display:flex; justify-content:center; align-items:center; text-decoration:none; color:white; font-size:12px;">
                    <i class="fa-solid fa-user"></i>
                </a> 
            </div>
        </div>

        <div class="greeting">
            <h2>Hi <?php echo explode(' ', $user['name'])[0]; ?>,</h2>
            <p style="font-size: 14px; color: #666;">You have <b style="color: #d9534f;"><?php echo $total_event; ?> event</b> this week</p>
        </div>

        <div class="hero-card">
            <div class="flex-between" style="align-items: flex-start;">
                <div>
                    <h1>Event <span style="font-size: 16px; font-weight: 400;">nearest</span></h1>
                    <ul class="hero-list">
                        <?php foreach($hero_events as $ev): ?>
                            <li><?php echo $ev['title']; ?> | <?php echo date('d M Y', strtotime($ev['date'])); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <a href="view_full_event.php" class="hero-btn">View Full Event</a>
        </div>

        <div class="section-title">
            Your Event <i class="fa-solid fa-circle-info" style="color: red; margin-left: 5px; font-size: 12px;"></i>
        </div>

        <div class="event-grid">
            <?php foreach($grid_events as $row): ?>
            <div class="event-card">
                <div>
                    <h4 class="event-title"><?php echo $row['title']; ?></h4>
                    <span class="badge <?php echo ($row['type'] == 'Required') ? 'badge-req' : 'badge-opt'; ?>">
                        <?php echo $row['type']; ?>
                    </span>
                </div>
                <div class="event-date">
                    <i class="fa-regular fa-clock"></i> <?php echo date('d M', strtotime($row['date'])); ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="bottom-nav">
            <a href="home.php" class="nav-item active">
                <i class="fa-solid fa-house"></i>
                Home
            </a>
            <a href="view_full_event.php" class="nav-item">
                <i class="fa-solid fa-book-open"></i>
                Event
            </a>
            <a href="barcode.php" class="nav-item">
                <i class="fa-solid fa-qrcode"></i>
                Barcode
            </a>
        </div>

    </div>
</body>
</html>